var side_tv = {
    options: {
        ratio                   : 0.55,
        xml_path                : "/include/filmdepo/filmdepo_mainpage_block.xml",
        swf_player_path         : '/vplayer/swf/vplayer.v2.5.1.swf',
        position                : 1,
        margin_bottom           : 5,
        autoscroll_delay        : 8000,
        autoscroll              : true,
        cookie_options          : { path: '/', expires: 365 },
        default_movie_width     : 960,
        default_movie_height    : 540,
        width                   : 240,
        resize: true
    },

    startAutoscroll: function(){
        this.options.autoscroll = true;
        clearInterval(this.autoscroll_interval);
        this.autoscroll_interval = setInterval('side_tv.moveRight()', this.options.autoscroll_delay);
    },

    stopAutoscroll: function(){
        this.options.autoscroll = false;
        clearInterval(this.autoscroll_interval);
    },

    setAutoscrollPause: function(){
        if(this.options.autoscroll){
            clearInterval(this.autoscroll_interval);
        };
    },

    unSetAutoscrollPause: function(){
        if(this.options.autoscroll){
            clearInterval(this.autoscroll_interval);
            this.autoscroll_interval = setInterval('side_tv.moveRight()', this.options.autoscroll_delay);
        };
    },

    setLoading: function(){
        $(this.options.selector).find('#pw_container').addClass('pw_loading');
    },

    unSetLoading: function(){
        $(this.options.selector).find('#pw_container').removeClass('pw_loading');
    },

    getMovieForHandheld: function(data){
        document.location.href = data.movie;
    },

    drawFlashPlayerFromDirectMoiveFile: function(data){
        $('body').prepend('<div id="flash_player_instance"></div>');
        this.createOverlay();

        var so = new SWFObject(this.options.swf_player_path, "flash_player_instance_embed", this.options.default_movie_width, this.options.default_movie_height, "9", "#000000");
        so.addParam("allowfullscreen","true");
        so.addParam("wmode", "transparent");
        so.addVariable("originalSize","1");
        so.addVariable("fromWidget","1");
        so.addVariable("cover", data.cover);
        so.addVariable("path", data.movie);
        so.addVariable("adFirst", "0");
        so.addVariable("autoplay", "1");
        so.write('flash_player_instance');

        var player =
            '<h1>'+ data.name +'</h1>' +
            '<a href="javascript:void(0)" id="player_close"></a>';

        $('#flash_player_instance').prepend(player);

        $('#flash_player_instance').css({
            width       : this.options.default_movie_width,
            marginLeft  : -this.options.default_movie_width/2,
            marginTop   : -$('#flash_player_instance').height()/2,
            top         : $(document).scrollTop()+$(window).height()/2
        });

        $('#player_close').click(function(){
            side_tv.closePlayer();
        });

        $('<p style="text-align: right; margin: 5px 10px;"><a href=" http://www.filmdepo.ru/cgi-bin/users_webcasts.pl?webcast_id='+data.item_id+'&utm_medium=partner&utm_source=ixbt&utm_campaign=video_splash" style="color: white;">  FilmDepo</a></p>').appendTo('#flash_player_instance');

        this.setAutoscrollPause();
    },

    drawFlashPlayer: function(data){
        $('body').prepend('<div id="flash_player_instance"></div>');
        this.createOverlay();

        var so = new SWFObject('http://www.filmdepo.ru/swf/player_filmdepo.swf', "flash_player_instance_embed", this.options.default_movie_width, this.options.default_movie_height, "9", "#000000");
        so.addParam("allowfullscreen","true");
        so.addParam("wmode", "transparent");
        so.addParam("allowscriptaccess", "always");
        so.addVariable("showEmbed","1");
        so.addVariable("id", data.item_id);
        so.addVariable("adFirst","0");
        so.addVariable("skipLastAd","1");
        so.addVariable("keepAspect","0");
        so.addVariable("autoload","0");
        so.write('flash_player_instance');

        var player =
            '<h1>'+ data.name +'</h1>' +
            '<a href="javascript:void(0)" id="player_close"></a>';

        $('#flash_player_instance').prepend(player);

        $('#flash_player_instance').css({
            width       : this.options.default_movie_width,
            marginLeft  : -this.options.default_movie_width/2,
            marginTop   : -$('#flash_player_instance').height()/2,
            top         : $(document).scrollTop()+$(window).height()/2
        });

        $('#player_close').click(function(){
            side_tv.closePlayer();
        });

        $('<p style="text-align: right; margin: 5px 10px;"><a href=" http://www.filmdepo.ru/cgi-bin/users_webcasts.pl?webcast_id='+data.item_id+'&utm_medium=partner&utm_source=ixbt&utm_campaign=video_splash" style="color: white;">  FilmDepo</a></p>').appendTo('#flash_player_instance');

        this.setAutoscrollPause();
    },

    drawHTML5Player: function(data){
        $('body').prepend('<div id="html5_player_instance" size="resized"></div>');
        this.createOverlay();

        var player =
            '<a href="javascript:void(0)" id="player_close"></a>' +
            '<h1>'+ data.name +'</h1>' +
            '<video ' +
            'class="html5_video_player" ' +
            'autoplay="autoplay" ' +
            'id="html5player" ' +
            'src="'+data.movie+'" ' +
            'poster="'+data.cover+'" ' +
            'width="'+this.options.default_movie_width+'" ' +
            'height="'+this.options.default_movie_height+'" ' +
            'controls="controls"></video>';

        $('#html5_player_instance').html(player);

        $('#html5_player_instance').css({
            width: this.options.default_movie_width,
            marginLeft: -this.options.default_movie_width/2,
            marginTop: -$('#html5_player_instance').height()/2,
            top: $(document).scrollTop()+$(window).height()/2
        });

        $('#player_close').click(function(){
            side_tv.closePlayer();
        });

        $('<p style="text-align: right; margin: 5px 10px;"><a href=" http://www.filmdepo.ru/cgi-bin/users_webcasts.pl?webcast_id='+data.item_id+'&utm_medium=partner&utm_source=ixbt&utm_campaign=video_splash" style="color: white;">  FilmDepo</a></p>').appendTo('#flash_player_instance');
    },

    playItem: function(obj){
        if(!FlashDetect.installed && !this.isiOSdevice() && !this.isAndroidDevice()){
            this.drawHTML5Player(obj.data().data);

        }else if(this.isiOSdevice() || this.isAndroidDevice()){
            this.getMovieForHandheld(obj.data().data);

        }else{
            this.drawFlashPlayer(obj.data().data);
        };
    },

    isiOSdevice: function(){
        var Device = {};

        Device.isiPhone = function(){
           return navigator.userAgent.indexOf('iPhone') != -1;
        };

        Device.isiPod = function(){
           return navigator.userAgent.indexOf('iPod') != -1;
        };

        Device.isiPad = function(){
           return navigator.userAgent.indexOf('iPad') != -1;
        };

        Device.isiOS = function(){
           return Device.isiPhone() || Device.isiPod() || Device.isiPad();
        };

        return Device.isiOS();
    },

    isAndroidDevice: function(){
        if(navigator.userAgent.indexOf('Android') > -1){
            return true;
        }
    },

    closePlayer: function(){
        this.destroyOverlay();

        if(!FlashDetect.installed){
            $('#html5_player_instance').remove();
        }else{
            $('#flash_player_instance').remove();
            $('#flash_player_instance_embed').remove();
        };

        this.unSetAutoscrollPause();
    },

    destroyOverlay: function(){
        $('#pw_overlay').remove();
    },

    createOverlay: function(){
        $('#pw_overlay').remove();
        $('body').prepend('<div id="pw_overlay"></div>');
        $('#pw_overlay').on('click', function(){
//            side_tv.closePlayer();
        });
    },

    drawItems: function(obj, i){
        var html = '<img src="'+obj.attr('thumb2').replace('http://www.filmdepo.ru/export/thumb/', '/include/filmdepo/img/')+'" />' +
                   '<span class="pw_item_name">'+obj.attr('name')+'</span>',

            item = $('<a></a>')
                    .addClass('pw_item')
                    .attr('rel', i)
                    .on('click', function(){side_tv.playItem($(this))})
                    .html(html);

        if(i == 1){
            item.addClass('pw_current');
        };

        item.data('data', {
            id          : i,
            item_id     : obj.attr('id'),
            name        : obj.attr('name'),
            movie       : obj.attr('movie'),
            cover       : obj.attr('cover'),
            width       : obj.attr('movieWidth'),
            height      : obj.attr('movieHeight'),
            adFirst     : obj.attr('adFirst')
        });

        $(this.options.selector).find('.pw_items>.pw_items_holder').append(item);
    },

    moveTo: function(n){
        this.options.position = parseInt(n);

        $(this.options.selector).find('.pw_items_holder').stop().animate({
            marginLeft: -(this.options.position-1) * this.options.item_width
        }, 400);

        $(this.options.selector).find('a.pw_item').removeClass('pw_current');
        $(this.options.selector).find('a.pw_item[rel="'+n+'"]').addClass('pw_current');

        this.setSizes();
    },

    moveLeft: function(){
        if(this.options.position - 1 < 1){
            this.options.position = this.options.items_count;
        }else{
            this.options.position--;
        };

        this.moveTo(this.options.position);
    },

    moveRight: function(){
        if(this.options.position + 1 > this.options.items_count){
            this.options.position = 1;
        }else{
            this.options.position++;
        };

        this.moveTo(this.options.position);
    },

    loadPreviews: function(){
        $.ajax({
            type: "GET",
            url: this.options.xml_path,
						cache: false,
            dataType: "xml",
            beforeSend: function(){
                side_tv.setSizes();
            },
            success: function(xml_data){
                var i = 0;

                $(xml_data).find('items').find('item').each(function(){
                    i++;
                    side_tv.drawItems($(this), i);
                });

                side_tv.options.items_count = i;
                side_tv.setSizes();
                side_tv.unSetLoading();
            }
        });
    },

    setSizes: function(){
        var parent_width        = (this.options.width == 'auto') ? $(this.options.selector).parent().width() : this.options.width,
            item_width          = parent_width - 14,
            total_width         = Math.ceil(item_width * side_tv.options.items_count),
            total_height        = $('#pw_container').height(),
            item_height         = Math.floor(item_width * this.options.ratio),
            name_height         = $(this.options.selector).find('.pw_items .pw_item.pw_current .pw_item_name').height() + 3;

        this.options.item_width = item_width;

        $(this.options.selector).find('.pw_items_holder').css({
            marginLeft: -(this.options.position-1) * this.options.item_width
        });

        $(this.options.selector).find('.pw_items').css({
            width   : item_width,
            height  : item_height + name_height
        });

        $(this.options.selector).find('.pw_items_holder').css({
            width   : total_width + item_width + 5,
            height  : item_height + name_height
        });

        $(this.options.selector).find('.pw_item, .pw_item>img').css({
            width   : item_width,
            height  : item_height
        });

        $(this.options.selector).css({
            width   : parent_width
        });

        $(this.options.selector).find('#pw_container .pw_left').css({
            height  : item_height
        });

        $(this.options.selector).find('#pw_container .pw_right').css({
            height  : item_height
        });
    },

    setItemsControls: function(){
        $(this.options.selector)
            .find('.pw_items')
            .on('mouseenter', function(){
                $(this).find('.pw_right').stop().animate({
                    right: 0
                }, 100);

                $(this).find('.pw_left').stop().animate({
                    left: 0
                }, 100);

                side_tv.setAutoscrollPause();
            })
            .on('mouseleave', function(){
                $(this).find('.pw_right').stop().animate({
                    right: -26
                }, 100);

                $(this).find('.pw_left').stop().animate({
                    left: -26
                }, 100);

                side_tv.unSetAutoscrollPause();
            });

        $(this.options.selector)
            .find('.pw_left')
            .on('click', function(){
                side_tv.moveLeft();
            });

        $(this.options.selector)
            .find('.pw_right')
            .on('click', function(){
            side_tv.moveRight();
        });

        $(this.options.selector)
            .find('.pw_right, .pw_left')
            .css({opacity: 0.4})
            .on('mouseenter', function(){
                $(this).css({
                    opacity: 0.6
                });
            })
            .on('mouseleave', function(){
                $(this).css({
                    opacity: 0.4
                });
            });
    },

    redrawAutocsrollButton: function(){
        if(this.options.autoscroll){
            $(this.options.selector).find('.pw_sliding_trigger').removeClass('pw_st_enabled').attr('title', ' ');
        }else{
            $(this.options.selector).find('.pw_sliding_trigger').addClass('pw_st_enabled').attr('title', ' ');
        };
    },

    toggleAutoscroll: function(){
        if(this.options.autoscroll){
            this.stopAutoscroll();
            $.cookie('pw_autoscroll', '0', this.options.cookie_options);
        }else{
            this.startAutoscroll();
            $.cookie('pw_autoscroll', '1', this.options.cookie_options);
        };

        this.redrawAutocsrollButton();
    },

    drawWidget: function(){
        var html =  '<div id="pw_container">' +
                        '<h3>iXBT TV</h3>' +
                        '<a class="pw_sliding_trigger" href="javascript:void(0)"></a>' +
                        '<div class="pw_items">' +
                            '<a class="pw_left" href="javascript:void(0)"><i></i></a>' +
                            '<a class="pw_right" href="javascript:void(0)"><i></i></a>' +
                            '<div class="pw_items_holder"></div>' +
                        '</div>' +
                    '</div>';

        $(this.options.selector).css({
            marginBottom: this.options.margin_bottom
        }).html(html);

        $(this.options.selector).find('.pw_sliding_trigger').on('click', function(){
            side_tv.toggleAutoscroll();
        });

        if($.cookie('pw_autoscroll') == '1' || !$.cookie('pw_autoscroll')){
            this.startAutoscroll();
        }else{
            this.stopAutoscroll();
        };

        this.redrawAutocsrollButton();
        this.setItemsControls();
        this.loadPreviews();
    },

    setResize: function(){
        $(window).on('resize', function(){
            side_tv.setSizes();
        });
    },

    resizePlayer: function(name, width, height){

        var container = $("#flash_player_instance");;
				var size;
        if(container.attr('size') == 'original' || container.attr('size') == ''){
            size = 'resized';
        }else{
            size = 'original';
            width = this.options.default_movie_width;
            height = this.options.default_movie_height;
        };

        container.css({
            width: parseInt(width),
            height: parseInt(height)+container.find('h1').height() + 7,
            marginLeft: -parseInt(width)/2,
            marginTop: -parseInt(height)/2
        }).attr('size', size);

        $('#flash_player_instance_embed').css({
            width: parseInt(width),
            height: parseInt(height)
        });
    },

    init: function(options){
        this.options = $.extend(this.options, options);
        this.drawWidget();
        this.setSizes();
        this.setLoading();
        if(this.options.resize === true){this.setResize()};
    }
};

function resizePlayerWidget(width, height, name){
	side_tv.resizePlayer(name, width, height);
};

function resizePlayer(width, height, name){
	side_tv.resizePlayer(name, width, height);
}